(function($) { 
    "use strict";

    const dike_slug = (pc_vars.dike_slug == 'pcbp') ? pc_vars.dike_slug : 'pcma';
    
    if(typeof(window.dike_plc) != 'undefined' && !window.dike_plc('lcweb', dike_slug)) {
        console.error('PvtContent Mail Actions add-on - validate the license');
        return false;    
    }
    
    
    
    
    /*****************************
       MANAGE PASSWORD RECOVERY
    ******************************/	

    let  pcma_psw_is_acting = false; // security var to avoid multiple calls

    // show recovery form
    $(document).on('click', '.pcma_psw_recovery_trigger', function() {
        const $pcma_form = $(this).parents('form');

        $pcma_form.children().hide();
        $pcma_form.find('.pcma_psw_recovery_wrap').fadeIn();
    });


    
    // hide recovery form
    $(document).on('click', '.pcma_del_recovery', function() {
        const $pcma_form = $(this).parents('form');

        $pcma_form.children().fadeIn();
        $pcma_form.find('.pcma_psw_recovery_wrap').hide();
    });


    
    // recaptcha v2 callback handling
    $(document).ready(function() {
        if(pc_vars.antispam_sys != 'recaptcha_v2') {
            return false;    
        }
        
        const action = 'pcma_psw_recover';
        $(document).on('pc_gcaptcha_v2_'+ action +'_validated', function(e, recaptcha_token) {
            submit_psw_recovery(window.pc_gcaptcha_v2_form, window.pc_gcaptcha_v2_f_data, recaptcha_token);
        });
    });
    
    
    
    // recovery request through click
    $(document).on('click', '.pcma_do_recovery', function(e) {
        e.preventDefault();
        
        const $form = $(this).parents('form').first(),
              f_data = new FormData($form[0]);
        
        submit_psw_recovery($form, f_data);        
    });
        
    // recovery request through enter key
    $(document).on('keyup', '.pcma_psw_username', function(e) {
        if(e.keyCode === 13) { 
            e.preventDefault();
            
            const $form = $(this).parents('form').first(),
                  f_data = new FormData($form[0]);
            
            submit_psw_recovery($form, f_data);        
        }
    });
    
    // perform recovery request
    const submit_psw_recovery = async function($form, f_data, recaptcha_token) {
        const pcma_username = $form.find('.pcma_psw_username').val().trim(),
              $mess_wrap = $form.find('.pcma_psw_recovery_message');

        if(pcma_psw_is_acting || !$.trim(pcma_username)) {
            return false;    
        }
        $mess_wrap.empty();
        
        // anti bruteforce
        if(pc_vars.abfa_blocked) {
            $mess_wrap.append('<span class="pc_error_mess">'+ pc_vars.abfa_error_mess +'</span></div>');
            return false;
        }
        
        
        // using honeypot?
        if($form.find('.pc_hnpt_code').length) {
            if(!window.pc_honeypot_is_valid($form)) {
                $mess_wrap.append('<div class="pc_error_mess"><span>Bot test not passed</span></div>');
                return false;
            }
        }
        
        
        // using recaptcha?
        else if($form.find('.pc_grecaptcha').length && typeof(recaptcha_token) == 'undefined') {

            // check if it hasn't been done yet
            if(typeof(grecaptcha) == 'undefined') {
                alert('recaptcha script not loaded');
            }
            const sitekey = pc_vars.recaptcha_sitekey;
            
            // recaptcha v3
            if(pc_vars.antispam_sys == 'recaptcha') {
                grecaptcha.ready(function() {
                    grecaptcha.execute( 
                        sitekey, 
                        {
                            action: 'submit'
                        }
                    ).then(function(token) {	
                        submit_psw_recovery($form, f_data, token);
                        return true;
                    });
                });
            }
            
            // recaptcha v2
            else if(pc_vars.antispam_sys == 'recaptcha_v2') {
                grecaptcha.ready(function() {
                    const $grecaptcha_wrap = $form.find('.pc_grecaptcha'),
                          elem_id = $form.find('.pc_grecaptcha').attr('id');
                    
                    let opt_widget_id;
                    
                    if($grecaptcha_wrap.is(':empty')) {
                        opt_widget_id = grecaptcha.render(elem_id, {
                            sitekey : sitekey,
                            size: 'invisible',
                        });
                        
                        $grecaptcha_wrap.data('opt-widget-id', opt_widget_id);
                    }
                    else {
                        opt_widget_id = $grecaptcha_wrap.data('opt-widget-id');
                    }
                    
                    window.pc_gcaptcha_v2_action = 'pcma_psw_recover';
                    window.pc_gcaptcha_v2_form = $form;
                    window.pc_gcaptcha_v2_f_data = f_data;
                    
                    window.pc_gcaptcha_v2_to_reset = opt_widget_id;
                    grecaptcha.execute(opt_widget_id);
                });
            }
            return false;	
        }
        /////
        
        
        $form.find('.pcma_do_recovery').addClass('pc_spinner_btn');
        $form.find('.pcma_del_recovery').fadeTo(150, 0);
        
        pcma_psw_is_acting = true;
        f_data.append('action', 'pcma_do_psw_recovery');
        
        if(typeof(recaptcha_token) != 'undefined') {
            f_data.append('grecaptcha_token', recaptcha_token);
        }

        await fetch(
            pc_vars.ajax_url,
            {
                method      : 'POST',
                credentials : 'same-origin',
                keepalive   : false,
                body        : f_data,
            }
        )
        .then(async response => {
            if(!response.ok) {
                return Promise.reject(response);
            }
            const pcma_data = await response.json().catch(e => {
                e.status = 500;
                return Promise.reject(e);
            });
            
            // success
            if(pcma_data.resp == 'success') {
                $mess_wrap.append('<span class="pc_success_mess">' + pcma_data.mess + '</span>');
                $('.pcma_do_recovery').hide().remove();
            }
            
            // error
            else {
                $mess_wrap.append('<span class="pc_error_mess">' + pcma_data.mess + '</span>');	

                // anti bruteforce
                if(pcma_data.abfa) {
                    pc_vars.abfa_blocked = true;    
                }
            }
        })
        .catch(e => {
            if(e.status) {
                console.error(e);
                $mess_wrap.append('<div class="pc_error_mess"><span>'+ pc_vars.ajax_failed_mess +'</span></div>');
            }
            return false;
        })
        .finally(() => {
            // a bit of delay to hide the loader
            pcma_psw_is_acting = false;
            
            // a bit of delay to display the loader
            setTimeout(function() {
                $form.find('.pcma_do_recovery').removeClass('pc_spinner_btn');
            }, 320);

            $form.find('.pcma_del_recovery').fadeTo(150, 1);   
        });
    };	
    
})(jQuery);	